<?php

return [
    'title' => 'Настройки',
    'general_setting' => 'Общи настройки',
    'menu' => 'Всички настройки',
    'email_setting_title' => 'Настройки на имейл',
    'email_setting_description' => 'Конфигуриране на настройките за имейл',
    'general' => [
        'theme' => 'Тема',
        'title' => 'Обща информация',
        'description' => 'Преглед и актуализиране на информацията за сайта',
        'rich_editor' => 'Богат редактор',
        'site_title' => 'Заглавие на сайта',
        'admin_email' => 'Имейл на администратора',
        'seo_block' => 'SEO конфигурация',
        'seo_title' => 'SEO заглавие',
        'seo_description' => 'SEO описание',
        'webmaster_tools_block' => 'Google Webmaster Tools',
        'placeholder' => [
            'site_title' => 'Заглавие на сайта (максимум 120 знака)',
            'admin_email' => 'Имейл на администратора',
            'seo_title' => 'SEO заглавие (максимум 120 знака)',
            'seo_description' => 'SEO описание (максимум 120 знака)',
            'google_analytics' => 'Google Analytics',
        ],
        'enable_send_error_reporting_via_email' => 'Изпращане на доклади за грешки по имейл',
        'enable_send_error_reporting_via_email_helper' => 'Когато е активирано, подробни доклади за грешки ще бъдат изпращани на имейл адресите на администратора, когато възникнат критични грешки на сайта',
        'time_zone' => 'Часова зона',
        'time_zone_helper' => 'Изберете часовата зона за вашия уебсайт. Това ще се използва за всички показвания на дата и час в цялата система',
        'enable' => 'Активиране',
        'disable' => 'Деактивиране',
        'disabled_helper' => 'Не може да се деактивира този имейл шаблон!',
        'enable_cache_site_map' => 'Активиране на кеширане на sitemap',
        'cache_time_site_map' => 'Време за кеш на sitemap (в минути)',
        'admin_logo' => 'Лого на администратора',
        'admin_favicon' => 'Favicon на администратора',
        'admin_title' => 'Заглавие на администратора',
        'admin_title_placeholder' => 'Заглавие за показване в раздела на браузъра',
        'admin_appearance_title' => 'Външен вид на администратора',
        'admin_appearance_description' => 'Настройка на външния вид на администратора като редактор, език...',
        'seo_block_description' => 'Настройка на заглавието на сайта, мета описание, ключови думи за оптимизация на SEO',
        'webmaster_tools_description' => 'Google Search Console е безплатен уеб инструмент, предоставен от Google, който помага на собствениците на уебсайтове да наблюдават представянето на сайта си в резултатите от търсенето на Google.',
        'yes' => 'Да',
        'no' => 'Не',
        'show_on_front' => 'Вашата начална страница показва',
        'select' => '— Избери —',
        'show_site_name' => 'Показване на името на сайта след заглавието на страницата, разделено с "-"',
        'locale' => 'Език на сайта',
        'locale_direction' => 'Посока на езика на сайта',
        'minutes' => 'минути',
        'redirect_404_to_homepage' => 'Пренасочване на всички заявки "Не е намерено" към началната страница',
    ],
    'admin_appearance' => [
        'title' => 'Външен вид на администратора',
        'description' => 'Преглед и актуализиране на лого, favicon, оформление,...',
        'layout' => 'Оформление',
        'layout_helper' => 'Изберете между хоризонтално меню (горна навигационна лента) или вертикално меню (странична навигационна лента)',
        'horizontal' => 'Хоризонтално',
        'vertical' => 'Вертикално',
        'show_menu_item_icon' => 'Показване на икона на елемент от менюто',
        'language' => 'Език на административния панел',
        'theme_mode' => 'Режим на темата',
        'dark' => 'Тъмен',
        'light' => 'Светъл',
        'container_width' => [
            'title' => 'Широчина на контейнера',
            'title_helper' => 'Задайте максималната ширина за контейнери със съдържание в административния панел',
            'default' => 'По подразбиране',
            'large' => 'Голям',
            'full' => 'Пълен',
        ],
        'form' => [
            'admin_logo' => 'Лого на администратора',
            'admin_logo_helper' => 'Качете персонализирано лого за показване в заглавната част на административния панел. Препоръчителен размер: 150x50px',
            'admin_logo_max_height' => 'Височина на логото (px)',
            'admin_logo_max_height_helper' => 'Задайте височината на логото в пиксели. Стойността по подразбиране е :default.',
            'admin_favicon' => 'Favicon на администратора',
            'admin_favicon_helper' => 'Качете favicon за административния панел. Тази икона се появява в разделите на браузъра и отметките',
            'admin_favicon_type' => 'Тип favicon на администратора',
            'admin_favicon_type_helper' => 'Изберете форма на изображението на вашия favicon. ICO формат се препоръчва за най-добра съвместимост с браузъра',
            'admin_title' => 'Заглавие на администратора',
            'admin_title_helper' => 'Задайте заглавието, което се появява в раздела на браузъра при преглед на административни страници',
            'admin_title_placeholder' => 'Заглавие за показване в раздела на браузъра',
            'admin_login_screen_backgrounds' => 'Фонове на екрана за вход (~1366 x 768)',
            'admin_login_screen_backgrounds_helper' => 'Качете едно или повече фонови изображения за екрана за вход. Изображенията ще се редуват произволно. Препоръчителен размер: 1366x768px',
            'admin_locale' => 'Език на администратора',
            'admin_locale_helper' => 'Изберете езика за интерфейса на административния панел',
            'admin_locale_direction' => 'Посока на езика на администратора',
            'admin_locale_direction_helper' => 'Задайте посоката на текста за административния панел. Изберете RTL за езици като арабски или иврит',
            'rich_editor' => 'Богат редактор',
            'rich_editor_helper' => 'Изберете редактора за форматиран текст по подразбиране за създаване на съдържание в целия административен панел',
            'primary_font' => 'Основен шрифт',
            'primary_font_helper' => 'Изберете основното семейство шрифтове за административния панел. Този шрифт ще се използва за повечето текст',
            'primary_color' => 'Основен цвят',
            'primary_color_helper' => 'Задайте основния цвят на темата, използван за бутони, връзки и акценти. По подразбиране: #206bc4',
            'secondary_color' => 'Вторичен цвят',
            'secondary_color_helper' => 'Задайте вторичния цвят на темата, използван за по-малко видими елементи на интерфейса. По подразбиране: #6c7a91',
            'heading_color' => 'Цвят на заглавието',
            'heading_color_helper' => 'Задайте цвета за заглавията в целия административен панел. Използвайте "inherit", за да използвате цвета на текста по подразбиране',
            'text_color' => 'Цвят на текста',
            'text_color_helper' => 'Задайте цвета на текста по подразбиране за административния панел. По подразбиране: #182433',
            'link_color' => 'Цвят на връзката',
            'link_color_helper' => 'Задайте цвета за връзките в административния панел. По подразбиране: #206bc4',
            'link_hover_color' => 'Цвят на връзката при посочване',
            'link_hover_color_helper' => 'Задайте цвета за връзките при посочване над тях. По подразбиране: #1a569d',
            'show_menu_item_icon' => 'Показване на икона на елемент от менюто',
            'show_menu_item_icon_helper' => 'Показване на икони до елементите от менюто в административната навигация за по-добро визуално разпознаване',
            'custom_css' => 'Персонализиран CSS',
            'custom_css_helper' => 'Добавете персонализирани CSS стилове, за да замените или разширите стиловете на административния панел по подразбиране',
            'custom_js' => 'Персонализиран JS',
            'custom_header_js' => 'Header JS',
            'custom_header_js_placeholder' => 'JavaScript в заглавната част на страницата, обградете го в &#x3C;script&#x3E;&#x3C;/script&#x3E;',
            'custom_body_js' => 'Body JS',
            'custom_body_js_placeholder' => 'JavaScript в тялото на страницата, обградете го в &#x3C;script&#x3E;&#x3C;/script&#x3E;',
            'custom_footer_js' => 'Footer JS',
            'custom_footer_js_placeholder' => 'JavaScript в долния колонтитул на страницата, обградете го в &#x3C;script&#x3E;&#x3C;/script&#x3E;',
        ],
    ],
    'datatable' => [
        'title' => 'Таблици с данни',
        'description' => 'Настройки за таблици с данни',
        'form' => [
            'show_column_visibility' => 'Показване на видимостта на колоните по подразбиране',
            'show_column_visibility_helper' => 'Активиране на бутона за видимост на колоните в таблиците с данни, за да позволите на потребителите да показват/скриват колони',
            'show_export_button' => 'Показване на бутон за експорт по подразбиране',
            'show_export_button_helper' => 'Показване на опции за експорт (CSV, Excel, PDF) в таблиците с данни за изтегляне на данни от таблицата',
            'pagination_type' => 'Тип страниране',
            'pagination_type_helper' => 'Изберете как се показват контролите за страниране: По подразбиране показва номера на страници, Падащо меню показва компактен селектор с падащо меню',
            'default' => 'По подразбиране',
            'dropdown' => 'Падащо меню',
            'enable_responsive' => 'Активиране на адаптивна таблица',
            'enable_responsive_helper' => 'Автоматично регулиране на колоните на таблицата, за да се побират на различни размери на екрана за по-добро мобилно изживяване',
        ],
    ],
    'email' => [
        'subject' => 'Тема',
        'content' => 'Съдържание',
        'title' => 'Настройка за имейл шаблон',
        'description' => 'Имейл шаблон, използващ HTML и системни променливи.',
        'reset_to_default' => 'Възстановяване по подразбиране',
        'back' => 'Назад към настройките',
        'reset_success' => 'Успешно възстановяване по подразбиране',
        'confirm_reset' => 'Потвърдете възстановяването на имейл шаблона?',
        'confirm_message' => 'Наистина ли искате да възстановите този имейл шаблон по подразбиране?',
        'continue' => 'Продължи',
        'sender_name' => 'Име на подателя',
        'sender_name_placeholder' => 'Име',
        'sender_name_helper' => 'Името, което ще се появи в полето От на имейлите, изпратени от системата',
        'sender_email' => 'Имейл на подателя',
        'sender_email_placeholder' => 'Имейл адрес (напр. :default)',
        'sender_email_helper' => 'Имейл адресът, който ще се използва като подател за всички имейли, изпратени от системата',
        'mailer' => 'Пощенски клиент',
        'port' => 'Порт',
        'port_placeholder' => 'Напр.: 587',
        'port_helper' => 'Портът, използван от вашия пощенски сървър (често срещани портове: 25, 465, 587)',
        'host' => 'Хост',
        'host_placeholder' => 'Напр.: smtp.gmail.com',
        'host_helper' => 'Адрес на SMTP хоста',
        'username' => 'Потребителско име',
        'username_placeholder' => 'Потребителско име за вход в пощенския сървър',
        'username_helper' => 'Вашето потребителско име за вход в пощенския сървър',
        'password' => 'Парола',
        'password_placeholder' => 'Парола за вход в пощенския сървър',
        'password_helper' => 'Вашата парола за вход в пощенския сървър',
        'encryption' => 'Криптиране',
        'encryption_placeholder' => 'Изберете тип криптиране',
        'encryption_helper' => 'Изберете метода на криптиране за сигурно предаване на имейл',
        'encryption_none' => 'Няма',
        'encryption_tls' => 'TLS',
        'encryption_ssl' => 'SSL',
        'setup_tips_title' => 'Съвети за настройка на имейл',
        'setup_tip_gmail' => 'За Gmail: Използвайте smtp.gmail.com като хост, порт 587 с TLS или порт 465 с SSL. Активирайте "Достъп за по-малко сигурни приложения" или използвайте парола за приложение.',
        'setup_tip_port' => 'Често срещани портове: 25 (некриптиран), 587 (TLS/STARTTLS), 465 (SSL/TLS), 2525 (алтернативен).',
        'setup_tip_encryption' => 'Използвайте TLS за порт 587 (препоръчително), SSL за порт 465 или Няма за порт 25 (не се препоръчва за продукция).',
        'setup_tip_test' => 'Винаги използвайте бутона "Изпрати тестов имейл", за да проверите конфигурацията си преди запазване.',
        'setup_tip_mailgun' => 'За по-добра доставимост помислете за използване на имейл услуги като Mailgun, SendGrid или Amazon SES вместо SMTP.',
        'queue_warning_title' => 'Изисква се конфигурация на опашката',
        'queue_warning_description' => 'Вашата опашка за имейли в момента е конфигурирана да използва драйвер ":default", но вашият работник на опашката може да не работи. Това означава, че имейлите няма да бъдат изпратени, докато не настроите работник на опашката.',
        'queue_warning_action' => 'За да изпращате имейли незабавно без работник на опашката, задайте QUEUE_CONNECTION=sync във вашия .env файл. В противен случай се уверете, че вашият работник на опашката работи с "php artisan queue:work". <a href="https://laravel.com/docs/12.x/queues" target="_blank" rel="noopener">Научете повече за Laravel Queues</a>.',
        'mail_gun_domain' => 'Домейн',
        'mail_gun_domain_placeholder' => 'Напр.: mg.yourdomain.com',
        'mail_gun_domain_helper' => 'Името на домейна, който сте регистрирали в Mailgun',
        'mail_gun_secret' => 'Тайна',
        'mail_gun_secret_placeholder' => 'Напр.: key-0123456789abcdef0123456789abcdef',
        'mail_gun_secret_helper' => 'Вашият API ключ за Mailgun',
        'mail_gun_endpoint' => 'Крайна точка',
        'mail_gun_endpoint_placeholder' => 'Напр.: api.mailgun.net',
        'mail_gun_endpoint_helper' => 'Крайна точка на Mailgun API (api.mailgun.net за САЩ, api.eu.mailgun.net за ЕС)',
        'log_channel' => 'Канал за логове',
        'log_channel_helper' => 'Изберете кой канал за логване да се използва за имейл логове',
        'sendmail_path' => 'Път на Sendmail',
        'local_domain' => 'Локален домейн',
        'local_domain_placeholder' => 'Може да бъде празно. Трябва да се зададе на вашия домейн при използване на SMTP Relay. Напр. your-domain.com',
        'local_domain_helper' => 'Домейнът, който ще се използва за идентифициране на сървъра при комуникация с отдалечени SMTP сървъри',
        'ses_key' => 'Ключ',
        'ses_key_placeholder' => 'Напр.: AKIAIOSFODNN7EXAMPLE',
        'ses_key_helper' => 'Вашият AWS access key ID',
        'ses_secret' => 'Тайна',
        'ses_secret_placeholder' => 'Напр.: wJalrXUtnFEMI/K7MDENG/bPxRfiCYEXAMPLEKEY',
        'ses_secret_helper' => 'Вашият AWS secret access key',
        'ses_region' => 'Регион',
        'ses_region_placeholder' => 'Напр.: us-east-1',
        'ses_region_helper' => 'AWS регионът, където е конфигурирана вашата SES услуга',
        'postmark_token' => 'Токен',
        'postmark_token_placeholder' => 'Напр.: 9a734df7-1c85-4b35-a98a-3d24cac1db1e',
        'postmark_token_helper' => 'Вашият токен за Postmark сървър',
        'resend_key' => 'API ключ',
        'resend_key_placeholder' => 'Напр.: re_123456789012345678901234567890',
        'resend_key_helper' => 'Вашият API ключ за Resend',
        'email_templates' => 'Имейл шаблони',
        'email_templates_description' => 'Имейл шаблони, използващи HTML и системни променливи.',
        'email_template_settings' => 'Настройки на имейл шаблона',
        'email_template_settings_description' => 'Преглед и актуализиране на настройките на вашите имейл шаблони',
        'email_rules' => 'Правила за имейл',
        'email_rules_description' => 'Конфигуриране на правила за имейл за валидация',
        'base_template' => 'Базов шаблон',
        'base_template_description' => 'Базов шаблон за всички имейли',
        'template_header' => 'Заглавна част на имейл шаблона',
        'template_header_description' => 'Шаблон за заглавната част на имейлите',
        'template_footer' => 'Долна част на имейл шаблона',
        'template_footer_description' => 'Шаблон за долната част на имейлите',
        'default' => 'По подразбиране',
        'template_off_status_helper' => 'Този имейл шаблон е изключен.',
        'blacklist_email_domains' => 'Блокирани имейл домейни',
        'blacklist_email_domains_helper' => 'Въведете списък с имейл домейни, които да бъдат блокирани. Напр. gmail.com, yahoo.com.',
        'blacklist_specified_emails' => 'Блокирани имейл адреси',
        'blacklist_specified_emails_helper' => 'Въведете списък с конкретни имейл адреси, които да бъдат блокирани. Напр. mail@example.com.',
        'exception_emails' => 'Изключени имейли',
        'exception_emails_helper' => 'Тези имейли ще бъдат изключени от правилата за валидация.',
        'email_rules_strict' => 'Строга валидация на имейл',
        'email_rules_strict_helper' => 'Извършване на валидация на имейл подобна на RFC със строги правила.',
        'email_rules_dns' => 'Валидация на DNS проверка',
        'email_rules_dns_helper' => 'Проверка дали има DNS записи, показващи, че сървърът приема имейли.',
        'email_rules_spoof' => 'Откриване на спуфинг',
        'email_rules_spoof_helper' => 'Откриване на потенциални опити за спуфинг на имейл.',
        'template_turn_off' => 'Щракнете, за да изключите този имейл шаблон',
        'template_turn_on' => 'Щракнете, за да включите този имейл шаблон',
        'turn_on_success_message' => 'Успешно включване на имейл шаблона!',
        'turn_off_success_message' => 'Успешно изключване на имейл шаблона!',
        'email_template_status' => 'Състояние на имейл шаблона',
        'email_template_status_description' => 'Включване/изключване на имейл шаблон',
        'email_template_logo' => 'Лого',
        'email_template_logo_helper_text' => 'Ако не е зададено, ще се вземе от логото на администратора в Admin -> Настройки -> Външен вид на администратора -> Лого.',
        'email_template_copyright_text_helper_text' => 'Ако не е зададено, ще се вземе от опциите на темата за авторски права в Admin -> Външен вид -> Опции на темата -> Общи -> Авторски права.',
        'email_template_email_contact' => 'Имейл адрес за контакт',
        'email_template_email_contact_helper_text' => 'Ако не е зададено, ще се вземе от имейла на подателя в Admin -> Настройки -> Имейл',
        'email_template_social_links' => 'Връзки към социални мрежи',
        'email_template_copyright_text' => 'Авторски права',
        'image_upload_supported' => 'Поддържа само PNG, JPG, JPEG и GIF формати.',
        'email_template_custom_css' => 'Персонализиран CSS на имейл шаблона',
        'social_links' => [
            'name' => 'Име',
            'icon' => 'Икона',
            'icon_image' => 'Изображение на иконата (Поддържа само PNG, JPG, JPEG и GIF формати.)',
            'url' => 'URL',
            'image' => 'Изображение',
        ],
        'logo_height' => 'Logo height (px)',
        'logo_height_helper' => 'Set the height of the logo in pixels. The default value is :default.',
    ],
    'license_title' => 'Лиценз',
    'setup_license' => 'Setup license code',
    'close' => 'Close',
    'media' => [
        'title' => 'Медия',
        'driver' => 'Драйвер',
        'description' => 'Настройки за медия',
        'local_disk' => 'Локален диск',
        'aws_access_key_id' => 'AWS Access Key ID',
        'aws_secret_key' => 'AWS Secret Key',
        'aws_default_region' => 'AWS регион по подразбиране',
        'aws_bucket' => 'AWS Bucket',
        'aws_url' => 'AWS URL',
        'aws_endpoint' => 'AWS Endpoint (По избор)',
        'use_path_style_endpoint' => 'Използване на endpoint в стил път',
        'r2_access_key_id' => 'R2 Access Key ID',
        'r2_secret_key' => 'R2 Secret Key',
        'r2_bucket' => 'R2 Bucket',
        'r2_url' => 'R2 URL',
        'r2_endpoint' => 'R2 Endpoint',
        'do_spaces_access_key_id' => 'DO Spaces Access Key ID',
        'do_spaces_secret_key' => 'DO Spaces Secret Key',
        'do_spaces_default_region' => 'DO Spaces регион по подразбиране',
        'do_spaces_bucket' => 'DO Spaces Bucket',
        'do_spaces_endpoint' => 'DO Spaces Endpoint',
        'do_spaces_cdn_enabled' => 'DO Spaces CDN активиран ли е?',
        'do_spaces_cdn_enabled_helper' => 'Когато е активирано, медийните файлове ще се обслужват чрез DigitalOcean Spaces CDN за по-бързо глобално доставяне на съдържание. По желание можете да конфигурирате потребителски CDN домейн по-долу.',
        'media_do_spaces_cdn_custom_domain' => 'Персонализиран домейн на DO Spaces CDN',
        'media_do_spaces_cdn_custom_domain_placeholder' => 'https://your-custom-domain.com',
        'wasabi_access_key_id' => 'Wasabi Access Key ID',
        'wasabi_secret_key' => 'Wasabi Secret Key',
        'wasabi_default_region' => 'Wasabi регион по подразбиране',
        'wasabi_bucket' => 'Wasabi Bucket',
        'wasabi_root' => 'Wasabi Root',
        'wasabi_root_helper' => 'За повторно използване на съществуващи изображения просто обозначете корена на Wasabi като "/", след това качете всички текущи файлове от public/storage в корневата директория на Wasabi.',
        'backblaze_access_key_id' => 'Backblaze Access Key ID',
        'backblaze_secret_key' => 'Backblaze Secret Key',
        'backblaze_bucket' => 'Backblaze Bucket',
        'backblaze_default_region' => 'Backblaze регион по подразбиране',
        'backblaze_url' => 'Backblaze URL',
        'backblaze_endpoint' => 'Backblaze Endpoint',
        'backblaze_cdn_enabled' => 'Backblaze CDN активиран ли е?',
        'backblaze_cdn_enabled_helper' => 'Когато е активирано, медийните файлове ще се обслужват чрез CDN за по-бързо глобално доставяне на съдържание. Трябва да конфигурирате потребителски CDN домейн по-долу (напр. Cloudflare CDN или Backblaze CDN).',
        'media_backblaze_cdn_custom_domain' => 'Персонализиран домейн на Backblaze CDN',
        'media_backblaze_cdn_custom_domain_placeholder' => 'https://your-custom-domain.com',
        'default_placeholder_image' => 'Изображение по подразбиране',
        'enable_chunk' => 'Активиране на качване на парчета',
        'chunk_size' => 'Размер на парчето (байтове)',
        'chunk_size_placeholder' => 'По подразбиране: 1048576 ~ 1MB',
        'max_file_size' => 'Максимален размер на файла за парче (MB)',
        'max_file_size_placeholder' => 'По подразбиране: 1048576 ~ 1GB',
        'enable_watermark' => 'Активиране на воден знак',
        'enable_watermark_helper' => 'Когато е активиран, водният знак автоматично ще се добавя към новокачени изображения в избрани папки. Това не засяга съществуващите изображения.',
        'watermark_source' => 'Изображение на воден знак',
        'watermark_source_helper' => 'Поддържа само PNG, JPG и JPEG формати. Трябва да използвате изображение под 200x200px и размер под 50KB.',
        'watermark_size' => 'Размер на водния знак (%)',
        'watermark_size_placeholder' => 'По подразбиране: 10 (%)',
        'watermark_opacity' => 'Непрозрачност на водния знак (%)',
        'watermark_opacity_placeholder' => 'По подразбиране: 70 (%)',
        'watermark_position' => 'Позиция на водния знак',
        'watermark_position_x' => 'Позиция X на водния знак',
        'watermark_position_y' => 'Позиция Y на водния знак',
        'watermark_position_top_left' => 'Горе вляво',
        'watermark_position_top_right' => 'Горе вдясно',
        'watermark_position_bottom_left' => 'Долу вляво',
        'watermark_position_bottom_right' => 'Долу вдясно',
        'watermark_position_center' => 'Център',
        'turn_off_automatic_url_translation_into_latin' => 'Изключване на автоматичния превод на URL на латиница',
        'turn_off_automatic_url_translation_into_latin_helper' => 'Когато е активирано, URL адресите на файлове няма да бъдат автоматично транслитерирани в латински знаци, запазвайки оригиналните знаци от нелатинските азбуки.',
        'bunnycdn_hostname' => 'Име на хост',
        'bunnycdn_zone' => 'Име на зоната (Името на вашата зона за съхранение)',
        'bunnycdn_key' => 'FTP & API парола за достъп (API паролата за достъп до зоната за съхранение)',
        'bunnycdn_region' => 'Регион (Регионът на зоната за съхранение)',
        'optional' => 'По избор',
        'sizes' => 'Размери на миниатюрите на медията',
        'media_sizes_helper' => 'Задайте ширина или височина на 0, ако искате да изрежете само по ширина или височина.',
        'width' => 'Ширина',
        'height' => 'Височина',
        'default_size_value' => 'По подразбиране: :size',
        'all' => 'Всички',
        'all_helper_text' => 'Ако премахнете отметката от всички папки, това ще се приложи за всички папки.',
        'media_folders_can_add_watermark' => 'Добавяне на воден знак за изображения в папки:',
        'max_upload_filesize' => 'Максимален размер на файла за качване (MB)',
        'max_upload_filesize_placeholder' => 'По подразбиране: :size, трябва да бъде по-малко от :size.',
        'max_upload_filesize_helper' => 'Вашият сървър позволява качване на файлове с максимален размер :size, можете да промените тази стойност, за да ограничите размера на файла за качване.',
        'image_processing_library' => 'Библиотека за обработка на изображения',
        'use_original_name_for_file_path' => 'Използване на оригиналното име за пътя на файла',
        'use_original_name_for_file_path_helper' => 'Когато е активирано, качените файлове ще запазят оригиналните си имена. Когато е деактивирано, имената на файловете ще бъдат преобразувани в удобни за URL охлузи (напр. „Моята снимка.jpg“ става „моята-снимка.jpg“).',
        'keep_original_file_size_and_quality' => 'Запазване на оригиналния размер и качество на файла',
        'keep_original_file_size_and_quality_helper' => 'Когато е активирано, качените изображения няма да бъдат преоразмерени или оптимизирани, запазвайки оригиналното си качество и размер на файла. Когато е деактивирано, изображенията могат да бъдат компресирани и преоразмерени въз основа на вашите настройки.',
        'update_thumbnail_sizes_warning' => 'След коригиране на размерите на миниатюрите трябва да щракнете върху бутона ":button_text", за да ги опресните.',
        'thumbnail_crop_position' => 'Позиция на изрязване на миниатюра',
        'thumbnail_crop_position_left' => 'Ляво',
        'thumbnail_crop_position_center' => 'Център',
        'thumbnail_crop_position_right' => 'Дясно',
        'thumbnail_crop_position_top' => 'Горе',
        'thumbnail_crop_position_bottom' => 'Долу',
        'thumbnail_crop_position_helper' => 'Тази настройка се използва за изрязване на изображението при генериране на миниатюри. То ще бъде изрязано от тази позиция, докато изображението се запълни.',
        'user_can_only_view_own_media' => 'Потребителите могат да виждат само своята медия',
        'user_can_only_view_own_media_helper' => 'Когато е активирано, потребителите могат да виждат само своята медия, докато супер администраторите могат да виждат цялата медия.',
        'enable_thumbnail_sizes' => 'Активиране на размерите на миниатюрите',
        'enable_thumbnail_sizes_helper' => 'Активирайте тази опция, за да генерирате миниатюри за изображения. Ако е деактивирана, системата няма да генерира миниатюри за изображения и винаги ще използва изображение в пълен размер.',
        'convert_image_to_webp' => 'Конвертиране на JPG, JPEG, PNG изображение в WebP',
        'convert_image_to_webp_helper' => 'WebP е съвременен формат на изображение, който предоставя превъзходно компресиране без загуби и с загуби за изображения в мрежата. Той се поддържа в Chrome, Firefox, Edge и Opera. Изображението ще бъде конвертирано във формат WebP при качване. Приложимо е само за JPG, JPEG, PNG изображения.',
        'reduce_large_image_size' => 'Намаляване на размера на големи изображения при качване',
        'reduce_large_image_size_helper' => 'Когато е активирано, системата ще намали размера на големи изображения при качване, приложимо за JPG, JPEG, PNG, WebP изображения. Максималната ширина и височина на изображението ще бъдат преоразмерени до стойностите, които зададете по-долу.',
        'image_max_width' => 'Максимална ширина на изображението (px)',
        'image_max_height' => 'Максимална височина на изображението (px)',
        'image_max_width_placeholder' => 'Оставете празно, за да запазите оригиналната ширина',
        'image_max_height_placeholder' => 'Оставете празно, за да запазите оригиналната височина',
        'image_max_width_helper' => 'Задайте максималната ширина на изображението в пиксели. Оригиналната ширина ще бъде запазена, ако това поле е празно.',
        'image_max_height_helper' => 'Задайте максималната височина на изображението в пиксели. Оригиналната височина ще бъде запазена, ако това поле е празно.',
        'customize_upload_path' => 'Персонализиране на пътя за качване',
        'customize_upload_path_helper' => 'Персонализирайте пътя за качване на медийни файлове. По подразбиране системата ще качва файлове в папката ":path".',
        'upload_path' => 'Път за качване',
        'upload_path_placeholder' => 'Пример: uploads',
        'upload_path_helper' => 'Тази папка ще бъде създадена в /public. Папката по подразбиране е ":folder". След това ще бъде качена в "/public/:folder".',
        'upload_path_warning' => 'Системата няма да премести съществуващите файлове в новата папка. Ако искате да преместите съществуващите файлове в новата папка, трябва да го направите ръчно.',
        'convert_file_name_to_uuid' => 'Конвертиране на името на файла в UUID',
        'convert_file_name_to_uuid_helper' => 'Когато е активирано, системата ще конвертира името на файла в UUID при качване. Това е полезно за предотвратяване на дублирани имена на файлове и по-добра сигурност.',
        's3_path' => 'Персонализиран S3 път (По избор)',
        's3_path_placeholder' => 'Незадължителен персонализиран път в S3 bucket (напр. uploads/media)',
    ],
    'field_type_not_exists' => 'This field type does not exist',
    'save_settings' => 'Запазване на настройките',
    'template' => 'Шаблон',
    'description' => 'Описание',
    'enable' => 'Активиране',
    'send' => 'Изпращане',
    'test_email_description' => 'За да изпратите тестов имейл, уверете се, че сте актуализирали конфигурациите за изпращане на имейл!',
    'test_email_input_placeholder' => 'Въведете имейл адреса, на който искате да изпратите тестов имейл.',
    'test_email_modal_title' => 'Изпращане на тестов имейл',
    'test_send_mail' => 'Изпращане на тестов имейл',
    'test_email_send_success' => 'Имейлът е изпратен успешно!',
    'locale_direction_ltr' => 'Отляво надясно',
    'locale_direction_rtl' => 'Отдясно наляво',
    'emails_warning' => 'Можете да добавите максимум :count имейли',
    'email_add_more' => 'Добави още',
    'generate' => 'Генериране',
    'generate_thumbnails' => 'Генериране на миниатюри',
    'generate_thumbnails_success' => 'Миниатюрите са генерирани успешно. :count файлове са генерирани!',
    'generate_thumbnails_error' => 'Не можахме да регенерираме миниатюри за :count файлове!',
    'generate_thumbnails_description' => 'Сигурни ли сте, че искате да регенерирате миниатюри за всички изображения? Това може да отнеме известно време. Моля, не напускайте тази страница, докато процесът не приключи.',
    'enable_chunk_description' => 'Качването на парчета се използва за качване на файлове с голям размер.',
    'watermark_description' => 'ВНИМАНИЕ: Водният знак се добавя само към нови качени изображения, няма да се добави към съществуващи изображения. Деактивирането на водния знак няма да премахне водния знак от съществуващи изображения.',
    'submit' => 'Изпращане',
    'back' => 'Назад',
    'enter_sample_value' => 'Въведете примерни стойности за тестване',
    'preview' => 'Преглед',
    'media_size_width' => 'Ширината на размера :size трябва да бъде по-голяма от 0',
    'media_size_height' => 'Височината на размера :size трябва да бъде по-голяма от 0',
    'security' => [
        'title' => 'Настройки за сигурност',
        'description' => 'Проверете и конфигурирайте настройките за сигурност на вашия уебсайт.',
        'menu_description' => 'Управление на сигурността на бисквитките и HTTP заглавките',
        'status_secure' => 'Всички настройки за сигурност са правилно конфигурирани!',
        'status_insecure' => 'Някои настройки за сигурност се нуждаят от внимание!',
        'current_settings' => 'Текущи настройки за сигурност',
        'status' => 'Състояние',
        'setting' => 'Настройка',
        'current_value' => 'Текуща стойност',
        'recommended_value' => 'Препоръчително',
        'session_http_only' => 'HttpOnly флаг на бисквитката',
        'session_http_only_description' => 'Предотвратява достъпа на JavaScript до бисквитките на сесията (защитава срещу XSS атаки)',
        'session_secure_cookie' => 'Secure флаг на бисквитката',
        'session_secure_cookie_description' => 'Осигурява изпращането на бисквитки само чрез HTTPS връзки',
        'session_same_site' => 'SameSite флаг на бисквитката',
        'session_same_site_description' => 'Предотвратява CSRF атаки чрез ограничаване кога се изпращат бисквитки',
        'http_security_headers' => 'HTTP заглавки за сигурност',
        'http_security_headers_description' => 'Добавя заглавки за сигурност за защита срещу често срещани уеб уязвимости',
        'https_warning' => 'Вашият сайт не използва HTTPS',
        'https_warning_description' => 'Някои функции за сигурност като защитени бисквитки изискват HTTPS. Помислете за активиране на SSL за вашия уебсайт.',
        'how_to_fix' => 'Как да поправите проблемите със сигурността',
        'env_file_location' => 'Редактирайте вашия .env файл, разположен на:',
        'add_to_env' => 'Настройки за добавяне',
        'required_settings' => 'Изискани настройки за сигурност',
        'for_https_sites' => 'Само за HTTPS сайтове',
        'copy' => 'Копиране',
        'copy_settings' => 'Копиране на всички настройки',
        'copied' => 'Копирано!',
        'steps' => 'Стъпки за прилагане на настройките',
        'step_1' => 'Отворете вашия .env файл в текстов редактор',
        'step_2' => 'Добавете или актуализирайте показаните по-горе настройки за сигурност',
        'step_3' => 'Запазете .env файла',
        'step_4' => 'Изчистете кеша чрез Admin Panel → Platform Administration → Cache Management',
        'security_headers_info' => 'Информация за заглавките за сигурност',
        'security_headers_list' => 'Когато е активирано, следните заглавки се добавят към всички отговори:',
        'header_nosniff' => 'Предотвратява браузърите да отгатват типове съдържание',
        'header_frame' => 'Защитава срещу clickjacking атаки',
        'header_xss' => 'Активира защитата на браузъра срещу XSS',
        'header_referrer' => 'Контролира колко информация за препращащия се изпраща',
        'learn_more' => 'За повече подробна информация вижте :documentation',
        'documentation' => 'документацията за сигурност',
    ],
    'cache' => [
        'title' => 'Кеш',
        'description' => 'Конфигуриране на кеширане за оптимизирана скорост',
        'form' => [
            'cache_admin_menu' => 'Кеширане на административното меню',
            'cache_admin_menu_helper' => 'Кеширане на административното меню за оптимизирана скорост. Тази опция трябва да бъде деактивирана, ако разработвате или персонализирате административното меню.',
            'enable_cache_site_map' => 'Кеширане на sitemap',
            'enable_cache_site_map_helper' => 'Sitemap :url трябва да се кешира поради големия брой страници. Ако имате малък брой страници, можете да деактивирате тази опция.',
            'cache_time_site_map' => 'Време за кеш на sitemap (в минути)',
            'cache_front_menu' => 'Кеширане на предното меню',
            'cache_front_menu_helper' => 'Кеширане на предното меню за оптимизирана скорост',
            'cache_user_avatar' => 'Кеширане на аватара на потребителя',
            'cache_user_avatar_helper' => 'За потребители без аватар системата ще генерира аватари от техните потребителски имена. Аватарите ще бъдат кеширани за оптимизирана скорост и няма да бъдат регенерирани.',
            'shortcode_cache_enabled' => 'Кеширане на кратки кодове (UI блокове)',
            'shortcode_cache_enabled_helper' => 'Активиране на кеширане за кратки кодове за подобряване на производителността. Когато е активирано, кратките кодове ще бъдат кеширани за намаляване на времето за рендиране.',
            'shortcode_cache_warning' => '<strong>⚠️ Важна бележка:</strong><br>• Кратките кодове, съдържащи формуляри (формуляри за контакт, абонаменти за бюлетин и т.н.), автоматично ще заобиколят кеширането, за да запазят функционалността.<br>• Кратките кодове с динамично JavaScript съдържание трябва да имат деактивирано кеширане ръчно.<br>• За да деактивирате кеширането за конкретни кратки кодове, добавете <code>Enable caching: No</code> към конфигурацията на краткия код.<br>• Формулярите с CSRF токени, reCAPTCHA или други динамични елементи се откриват автоматично и се изключват от кеширането.',
            'shortcode_cache_ttl' => 'Продължителност на кеша (секунди)',
            'shortcode_cache_ttl_helper' => 'Продължителността за кеширане на всички кратки кодове. По подразбиране е 1800 секунди (30 минути).',
            'widget_cache_enabled' => 'Кеширане на уиджети',
            'widget_cache_enabled_helper' => 'Активиране на кеширане за уиджети за подобряване на производителността. Когато е активирано, уиджетите ще бъдат кеширани за намаляване на времето за рендиране.',
            'widget_cache_warning' => '<strong>⚠️ Важна бележка:</strong><br>• Уиджетите, съдържащи формуляри (формуляри за контакт, абонаменти за бюлетин и т.н.), автоматично ще заобиколят кеширането, за да запазят функционалността.<br>• Уиджетите с динамично JavaScript съдържание трябва да имат деактивирано кеширане ръчно.<br>• За да деактивирате кеширането за конкретни уиджети, задайте <code>Enable caching: No</code> в конфигурацията на уиджета.<br>• Формулярите с CSRF токени, reCAPTCHA или други динамични елементи се откриват автоматично и се изключват от кеширането.',
            'widget_cache_ttl' => 'Продължителност на кеша (секунди)',
            'widget_cache_ttl_helper' => 'Продължителността за кеширане на всички уиджети. По подразбиране е 1800 секунди (30 минути).',
            'plugin_cache_enabled' => 'Кеширане на инсталирани плъгини',
            'plugin_cache_enabled_helper' => 'Кеширане на списъка с инсталирани плъгини за подобрена производителност. Когато е активирано, системата ще кешира списъка с плъгини за 30 минути, за да намали сканирането на файловата система.',
        ],
    ],
    'appearance' => [
        'title' => 'Външен вид',
    ],
    'panel' => [
        'common' => 'Общи',
        'general' => 'Общи',
        'general_description' => 'Преглед и актуализиране на вашите общи настройки и активиране на лиценза',
        'email' => 'Имейл',
        'email_description' => 'Преглед и актуализиране на вашите настройки за имейл и имейл шаблони',
        'media' => 'Медия',
        'media_description' => 'Преглед и актуализиране на вашите настройки за медия',
        'system' => 'Система',
        'system_updater' => 'Актуализатор на системата',
        'system_updater_description' => 'Актуализиране на вашата система до най-новата версия',
        'others' => 'Други',
    ],
    'saving' => 'Запазване...',
    'generating_media_thumbnails' => 'Генериране на миниатюри на медия...',
    'test_email_template' => 'Тестване на имейл шаблон',
    'select_email_template' => 'Изберете имейл шаблон',
    'enums' => [
        'data_retention_period' => [
            0 => 'Никога',
            1 => '1 ден',
            3 => '3 дни',
            7 => '1 седмица',
            30 => '1 месец',
            90 => '3 месеца',
            180 => '6 месеца',
            365 => '1 година',
        ],
    ],
    'validation' => [
        'aws_region_invalid' => ':attribute трябва да бъде валиден AWS регион (напр. us-east-1, eu-west-1).',
    ],
    'phone_number' => [
        'title' => 'Phone Number',
        'description' => 'Configure phone number field settings',
        'enable_country_code' => 'Enable Country Code Selection',
        'enable_country_code_helper' => 'When enabled, phone number fields will display a country code selector with automatic country detection.',
        'available_countries' => 'Available Countries',
        'all' => 'All',
        'all_helper_text' => 'Select all countries to be available in the phone country code selector.',
        'min_length' => 'Minimum Length',
        'min_length_helper' => 'Minimum number of characters required for phone numbers.',
        'max_length' => 'Maximum Length',
        'max_length_helper' => 'Maximum number of characters allowed for phone numbers.',        'note_content' => '<p class="mb-1"><strong>За локален формат (без код на страната):</strong> Задайте мин/макс въз основа на дължината на телефонния номер на вашата страна (напр. 8-15 за повечето страни).</p><p class="mb-0"><strong>За международен формат (с активиран код на страната):</strong> Препоръчително мин: 7, макс: 20. Това обхваща кодове на страни (1-4 цифри) + телефонни номера (обикновено 6-15 цифри).</p>',
    ],
];
