<?php

namespace FriendsOfBotble\Comment\Forms\Settings;

use Botble\Base\Facades\Html;
use Botble\Base\Forms\FieldOptions\ColorFieldOption;
use Botble\Base\Forms\FieldOptions\MediaImageFieldOption;
use Botble\Base\Forms\FieldOptions\NumberFieldOption;
use Botble\Base\Forms\FieldOptions\OnOffFieldOption;
use Botble\Base\Forms\FieldOptions\RadioFieldOption;
use Botble\Base\Forms\FieldOptions\SelectFieldOption;
use Botble\Base\Forms\Fields\ColorField;
use Botble\Base\Forms\Fields\MediaImageField;
use Botble\Base\Forms\Fields\NumberField;
use Botble\Base\Forms\Fields\OnOffCheckboxField;
use Botble\Base\Forms\Fields\RadioField;
use Botble\Base\Forms\Fields\SelectField;
use Botble\Base\Forms\FormAbstract;
use Botble\Captcha\Facades\Captcha;
use Botble\Setting\Forms\SettingForm;
use FriendsOfBotble\Comment\Http\Requests\Settings\CommentSettingRequest;
use FriendsOfBotble\Comment\Support\CommentHelper;

class CommentSettingForm extends SettingForm
{
    public function setup(): void
    {
        parent::setup();

        $this
            ->setValidatorClass(CommentSettingRequest::class)
            ->setSectionTitle(trans('plugins/fob-comment::comment.settings.title'))
            ->setSectionDescription(trans('plugins/fob-comment::comment.settings.description'))
            ->when(is_plugin_active('captcha'), function (FormAbstract $form): void {
                $form->add(
                    'fob_comment_enable_recaptcha',
                    OnOffCheckboxField::class,
                    OnOffFieldOption::make()
                        ->label(trans('plugins/fob-comment::comment.settings.form.enable_recaptcha'))
                        ->value(setting('fob_comment_enable_recaptcha', false))
                        ->when(! Captcha::isEnabled(), function (OnOffFieldOption $option) {
                            return $option->helperText(
                                trans(
                                    'plugins/fob-comment::comment.settings.form.enable_recaptcha_help',
                                    ['url' => Html::link(
                                        route('captcha.settings'),
                                        trans('plugins/fob-comment::comment.settings.form.captcha_setting_label')
                                    )]
                                )
                            );
                        })
                        ->toArray()
                );
            })
            ->when(CommentHelper::hasMultipleAuthGuards(), function (FormAbstract $form): void {
                $form->add(
                    'fob_comment_disable_guest_comment',
                    OnOffCheckboxField::class,
                    OnOffFieldOption::make()
                        ->label(trans('plugins/fob-comment::comment.settings.form.disable_guest_comment'))
                        ->helperText(trans('plugins/fob-comment::comment.settings.form.disable_guest_comment_help'))
                        ->value(CommentHelper::isGuestCommentDisabled())
                        ->toArray()
                );
            })
            ->add(
                'fob_comment_comment_moderation',
                OnOffCheckboxField::class,
                OnOffFieldOption::make()
                    ->label(trans('plugins/fob-comment::comment.settings.form.comment_moderation'))
                    ->helperText(trans('plugins/fob-comment::comment.settings.form.comment_moderation_help'))
                    ->value(CommentHelper::commentMustBeModerated())
                    ->toArray()
            )
            ->add(
                'fob_comment_rate_limit_seconds',
                NumberField::class,
                NumberFieldOption::make()
                    ->label(trans('plugins/fob-comment::comment.settings.form.rate_limit_seconds'))
                    ->helperText(trans('plugins/fob-comment::comment.settings.form.rate_limit_seconds_help'))
                    ->value(CommentHelper::getRateLimitSeconds())
                    ->toArray()
            )
            ->add(
                'fob_comment_show_comment_cookie_consent',
                OnOffCheckboxField::class,
                OnOffFieldOption::make()
                    ->label(trans('plugins/fob-comment::comment.settings.form.show_comment_cookie_consent'))
                    ->helperText(trans('plugins/fob-comment::comment.settings.form.show_comment_cookie_consent_help'))
                    ->value(CommentHelper::isShowCommentCookieConsent())
                    ->toArray()
            )
            ->add(
                'fob_comment_email_optional',
                OnOffCheckboxField::class,
                OnOffFieldOption::make()
                    ->label(trans('plugins/fob-comment::comment.settings.form.email_optional'))
                    ->helperText(trans('plugins/fob-comment::comment.settings.form.email_optional_help'))
                    ->value(setting('fob_comment_email_optional', false))
                    ->toArray()
            )
            ->add(
                'fob_comment_show_website_field',
                OnOffCheckboxField::class,
                OnOffFieldOption::make()
                    ->label(trans('plugins/fob-comment::comment.settings.form.show_website_field'))
                    ->helperText(trans('plugins/fob-comment::comment.settings.form.show_website_field_help'))
                    ->value(CommentHelper::isShowWebsiteField())
                    ->toArray()
            )
            ->add(
                'fob_comment_auto_fill_comment_form',
                OnOffCheckboxField::class,
                OnOffFieldOption::make()
                    ->label(trans('plugins/fob-comment::comment.settings.form.auto_fill_comment_form'))
                    ->value(CommentHelper::isAutoFillCommentForm())
                    ->helperText(trans('plugins/fob-comment::comment.settings.form.auto_fill_comment_form_help'))
                    ->toArray()
            )
            ->add(
                'fob_comment_comment_order',
                RadioField::class,
                RadioFieldOption::make()
                    ->label(trans('plugins/fob-comment::comment.settings.form.comment_order'))
                    ->helperText(trans('plugins/fob-comment::comment.settings.form.comment_order_help'))
                    ->choices([
                        'asc' => trans('plugins/fob-comment::comment.settings.form.comment_order_choices.asc'),
                        'desc' => trans('plugins/fob-comment::comment.settings.form.comment_order_choices.desc'),
                    ])
                    ->selected(CommentHelper::getCommentOrder())
                    ->toArray()
            )
            ->add(
                'fob_comment_display_admin_badge',
                OnOffCheckboxField::class,
                OnOffFieldOption::make()
                    ->label(trans('plugins/fob-comment::comment.settings.form.display_admin_badge'))
                    ->helperText(trans('plugins/fob-comment::comment.settings.form.display_admin_badge_help'))
                    ->value(CommentHelper::isDisplayAdminBadge())
                    ->toArray()
            )
            ->add(
                'fob_comment_show_admin_role_name_for_admin_badge',
                OnOffCheckboxField::class,
                OnOffFieldOption::make()
                    ->label(trans('plugins/fob-comment::comment.settings.form.show_admin_role_name_for_admin_badge'))
                    ->helperText(trans('plugins/fob-comment::comment.settings.form.show_admin_role_name_for_admin_badge_helper'))
                    ->value(setting('fob_comment_show_admin_role_name_for_admin_badge', 'true'))
                    ->toArray()
            )
            ->add(
                'fob_comment_avatar_provider',
                SelectField::class,
                SelectFieldOption::make()
                    ->label(trans('plugins/fob-comment::comment.settings.form.avatar_provider'))
                    ->helperText(trans('plugins/fob-comment::comment.settings.form.avatar_provider_help'))
                    ->choices([
                        'gravatar' => trans('plugins/fob-comment::comment.settings.form.avatar_provider_choices.gravatar'),
                        'ui_avatars' => trans('plugins/fob-comment::comment.settings.form.avatar_provider_choices.ui_avatars'),
                    ])
                    ->selected(setting('fob_comment_avatar_provider', 'gravatar'))
                    ->toArray()
            )
            ->add(
                'fob_comment_default_avatar',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->label(trans('plugins/fob-comment::comment.settings.form.default_avatar'))
                    ->helperText(trans('plugins/fob-comment::comment.settings.form.default_avatar_helper'))
                    ->value(setting('fob_comment_default_avatar'))
                    ->toArray()
            )
            ->add(
                'fob_comment_allow_author_delete',
                OnOffCheckboxField::class,
                OnOffFieldOption::make()
                    ->label(trans('plugins/fob-comment::comment.settings.form.allow_author_delete'))
                    ->helperText(trans('plugins/fob-comment::comment.settings.form.allow_author_delete_help'))
                    ->value(CommentHelper::isAllowAuthorDelete())
                    ->toArray()
            )
            ->add(
                'fob_comment_primary_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(trans('plugins/fob-comment::comment.settings.form.primary_color'))
                    ->helperText(trans('plugins/fob-comment::comment.settings.form.primary_color_helper'))
                    ->value(setting('fob_comment_primary_color'))
                    ->toArray()
            )
            ->add(
                'fob_comment_primary_color_hover',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(trans('plugins/fob-comment::comment.settings.form.primary_color_hover'))
                    ->helperText(trans('plugins/fob-comment::comment.settings.form.primary_color_hover_helper'))
                    ->value(setting('fob_comment_primary_color_hover'))
                    ->toArray()
            );
    }
}
